#!/usr/bin/python
import time,random,sys,datetime,AMPS
SYMBOLS = ( "AAAA", "BBBB", "CCCC", "DDDD", "EEEE", "FFFF", "GGGG", "HHHH")
TOPIC = "ORDERS"
PORT = 9005


def publish(client, size):
    m = client.allocateMessage()
    m.setCommand("publish")
    m.setTopic(TOPIC)
    
    for i in xrange(size):
        data = "Key=%d\x01Symbol=%s\x01UnitPrice=%.2f\x01Qty=%d\x01" % (i,SYMBOLS[i%len(SYMBOLS)],random.random()*100.0,random.random()*10000)
        m.setData(data)
        client.send(m)
        if i%10000 == 0 and sys.stdout.isatty():
            sys.stdout.write(('\b'*80) + ("published %d (%d%% complete)"%(i,100.0*i/size)))
    sys.stdout.write(('\b'*80) + ("published %d (100%% complete)\n"%size))
    sys.stdout.flush()


def update(client, size, rate):
	str_len = 0
	total_updates = 0
	m = client.allocateMessage()
	m.setCommand("delta_publish")
	m.setTopic(TOPIC)
 
	while (1):   
		start_dt = datetime.datetime.now()
		ri = random.randint(1, size)
		for i in xrange(rate):
			data = "Key=%d\x01Symbol=%s\x01UnitPrice=%.2f\x01Qty=%d\x01" % (ri,SYMBOLS[ri%len(SYMBOLS)],random.random()*100.0,random.randint(0, 10000) )
			m.setData(data)
			client.send(m)
		total_updates += rate
		sys.stdout.write('\b' * str_len)	
		upd_str = "%d updates published" % (total_updates)
		sys.stdout.write(upd_str)
		sys.stdout.flush()
		str_len = len(upd_str)	
		end_dt = datetime.datetime.now()
		diff = end_dt - start_dt
		#sleep for the rest of the second if burst took less than a second
		if (diff.microseconds < 1000000):
			time.sleep((1000000.0 - diff.microseconds) / 1000000.0)


def print_usage():
    print """
usage: %(app)s <init|update> <hostname> <millions-of-records> [update-rate]
  examples:

     %(app)s init localhost 1

        publishes 1 million records into the ORDERS topic
        of the AMPS instance running on port 9005 of localhost.
     
     %(app)s update localhost 1 1000
     
        publishes random updates to a set of 1 million records
        in the ORDERS topic at a rate of 1000 updates per second.
     """ % {'app':sys.argv[0]}

if len(sys.argv) < 4:
	print_usage()	
	sys.exit(-1)

if sys.argv[1] == 'init':
	if (len(sys.argv) != 4):
		print_usage()
		sys.exit(-1)
elif sys.argv[1] == 'update':
	if (len(sys.argv) != 5):
		print_usage()
		sys.exit(-1)
else:
	print 'action must be init or update'
	print_usage()
	sys.exit(-1)


function = sys.argv[1]
hostname = sys.argv[2]
millions = sys.argv[3]
client = AMPS.Client("ordview-publisher")
client.connect("tcp://%s:%d/nvfix"%(hostname, PORT))
client.logon()

if (function == "init"):
	publish(client, int(millions) * 1000 * 1000)
else:
	update(client, int(millions) * 1000 * 1000, int(sys.argv[4]))
	

client.disconnect()
                                                                                                                                            

