package com.crankuptheamps.examples;

import com.crankuptheamps.client.*;
import com.crankuptheamps.client.exception.*;

//ConsolePublisher
//
//This is a minimalist way of publishing messages to a topic in AMPS.
//The program flow is simple:
//
//* Connect to AMPS
//* Logon
//* Publish a message the "messages" topic 
//
//This sample doesn't include error handling or connection
//retry logic.
//
//(c) 2014-2016 60East Technologies, Inc. All rights reserved.
//This file is a part of the AMPS Evaluation Kit.
public class ConsolePublisher {

  // The location of the AMPS server.
  private static final String uri_ = "tcp://127.0.0.1:9007/amps/json";

  /**
   * main method.
   *
   * @param args -- No command line options read.
   */
  public static void main(String[] args) {
    System.out.println("Starting the console publisher.");

    try (HAClient client = new HAClient("ConsolePublisher");) {
      // wait a bit to give a subscriber time to listen
      Thread.sleep(2000L);

      // Create a custom server chooser
      DefaultServerChooser serverChooser = new DefaultServerChooser();
      serverChooser.add(uri_);
    
     // Set the server chooser for the HAClient
     client.setServerChooser(serverChooser);
     // connect to the AMPS server and logon
     client.connectAndLogon();
     System.out.println("Publisher Connected");
      

      client.publish("messages", "{\"message\" : \"Hello, World!\"}");
    }
    catch (Exception e)
    {
      System.err.println(e.getLocalizedMessage());
      e.printStackTrace(System.err);
    }

  }

}

