////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;
import java.util.Properties;
import java.net.URI;

/**
  * Provides a Properties-sytle interface to the parameters in a URI.
  */
public class URIProperties extends Properties
{
    private static final long serialVersionUID = 1;

    public URIProperties(URI uri_)
    {
        parse(uri_);
    }

    private void parse(URI uri_)
    {
        this.clear();
        String query = uri_.getQuery();
        if(query == null) return;

        int currentKey = 0, currentKeyLen = 0, currentValue = 0;
        for(int i = 0; i < query.length(); i++)
        {
            if(currentValue == 0)   // parsing the key
            {
                if(query.charAt(i) == '=')
                {
                    currentValue = i+1;
                    currentKeyLen = i-currentKey;
                }
            }
            else
            {
                if(query.charAt(i) == '&')
                {
                    this.put( query.substring( currentKey, currentKeyLen+currentKey ),
                              query.substring( currentValue, i) );
                    currentKey = i+1;
                    currentValue = 0;
                }
            }
        }
        if(currentValue > currentKey)   // last one
        {
            this.put( query.substring( currentKey, currentKeyLen+currentKey ),
                      query.substring( currentValue ) );
        }
    }
}


