///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.client;

import java.util.LinkedList;

/**
 * A simple generic instance pool for objects that take a while to construct.
 *
 *
 * @param <T> The pooled type.
 */
public class Pool<T>
{
    int _initialSize = 0;
    LinkedList<T> _freePool = new LinkedList<T>();

    Class<T> _theClass;

    /**
     * Constructs a pool with the given size
     * @param theClass The Class pooled. Should always be T.class. Sorry we can't do this ourselves.
     * @param initialSize The initial size of the pool. If you pass a value less than 1, we'll just use 1.
     */
    // Porting note: don't pass in the Class, just constrain T with 'new'
    // and new Ts off the heap.
    public Pool(Class<T> theClass, int initialSize)
    {
        _theClass = theClass;
        if(initialSize < 1) initialSize = 1;
        _initialSize = initialSize;
        grow();
    }

    private void grow()
    {
        for(int i = 0; i < _initialSize; ++i)
        {
            try
            {
                _freePool.add(_theClass.newInstance());
            } catch (Exception e)
            {
                // we count on this not happening.
                e.printStackTrace();
            }
        }
    }

    /**
     * Returns an object from the pool, growing self if necessary (by initialSize).
     * If T cannot be instantiated, returns null.
     * @return A pooled instance.
     */
    public synchronized T get()
    {
        if(_freePool.size() < 1)
        {
            grow();
        }
        return _freePool.removeFirst();
    }

    /**
     * Return an object to the pool. Note, you're responsible for clear/reset of objects being returned.
     * @param theInstance The T to return to the pool.
     */
    public synchronized void returnToPool(T theInstance)
    {
        // theInstance must be reset prior to return
        _freePool.add(theInstance);
    }
}
