////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;
import com.crankuptheamps.client.exception.AMPSException;
import java.util.*;

public class MemorySubscriptionManager implements SubscriptionManager
{
    static long DefaultResubscriptionTimeout = 10000;

    static class SubscriptionInfo
    {
        Message _message = null;
        MessageHandler _handler;
        int _command;
        CommandId _subId;
        String _topic, _filter, _bookmark;
        String _options;
        int _batchSize;
        
        SubscriptionInfo(MessageHandler messageHandler, int command,
            CommandId subId, String topic, String filter, String bookmark, String options, int batchSize)
        {
            _handler = messageHandler;
            _command = command;
            _subId = subId;
            _topic = topic;
            _filter = filter;
            _bookmark = bookmark;
            // Don't set replace, this is only used for resubscribe
            _options = options;
        }

        void resubscribe(Client client) throws AMPSException
        {
            Command cmd = new Command(_command).setCommandId(_subId).setQueryId(_subId).setTopic(_topic).setSubId(_subId).setBatchSize(_batchSize).setFilter(_filter).setOptions(_options);
            
            if(_bookmark != null)
            {
                // Always resubscribe to the most recent.
                cmd.setBookmark(Client.Bookmarks.MOST_RECENT);
            }
            client.executeAsync(cmd,_handler);
        }
    }
        
    private HashMap<CommandId, SubscriptionInfo> _active = new HashMap<CommandId, SubscriptionInfo>();
    boolean _resubscribing = false;
    public void subscribe(MessageHandler messageHandler, int command,
                           CommandId subId, String topic, String filter, String bookmark, String options,
                           int batchSize)
    {
        _active.put(subId, new SubscriptionInfo(messageHandler, command, subId, topic,
            filter, bookmark, options, batchSize));
    }

    public void unsubscribe(CommandId subId)
    {
        if(!_resubscribing)
        {
            _active.remove(subId);
        }
    }

    public void clear()
    {
        _active.clear();
    }

    public void resubscribe(Client client) throws AMPSException
    {
        _resubscribing = true;
        try
        {
            for(SubscriptionInfo si : _active.values())
            {
                si.resubscribe(client);
            }
        }
        finally
        {
            _resubscribing = false;
        }
    }

    public static void setDefaultResubscriptionTimeout(long timeout)
    {
        DefaultResubscriptionTimeout = timeout;
    }


}
