package com.crankuptheamps.client;
import java.util.HashMap;

import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.BookmarkField;

public class DefaultBookmarkStore implements BookmarkStore
{
    private HashMap<Field, Field> _inMemStore;

    public DefaultBookmarkStore()
    {
        _inMemStore = new HashMap<Field, Field>();
    }

    public synchronized long log(Message message)
    {
        _inMemStore.put(message.getSubIdRaw(), message.getBookmarkRaw());
        return 0;
    }

    public void discard(Field topic, long bookmarkSequenceNumber)
    {
        // No-op
    }
    
    public void discard(Message message) throws AMPSException
    {
    	discard(message.getSubIdRaw(), message.getBookmarkSeqNo());
    }
    
    public synchronized Field getMostRecent(Field topic)
    {
        // return the epoch if we haven't seen anything yet.
        return _inMemStore.containsKey(topic)?_inMemStore.get(topic):new Field("0");

    }

    // all messages should be delivered.
    public boolean isDiscarded(Message message)
    {
        return false;
    }
    
    public synchronized void purge() throws AMPSException
    {
        _inMemStore = new HashMap<Field, Field>();        
    }

    public void persisted(Field subId, BookmarkField bookmark) throws AMPSException
    {
        // no-op
    }

    public void persisted(Field subId, long bookmark) throws AMPSException
    {
        // no-op
    }

    public void noPersistedAcks(Field subId) throws AMPSException
    {
        // no-op
    }

    public synchronized long getOldestBookmarkSeq(Field subId) throws AMPSException
    {
        return 0;
    }

    public void setResizeHandler(BookmarkStoreResizeHandler handler)
    {
        // no-op
    }

    public void setServerVersion(int version_)
    {
        // no-op
    }

}

