/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.spark.CommandOption;
import com.crankuptheamps.spark.SparkCommand;
import java.util.UUID;

public class SOWAndSubscribeCommand
extends SparkCommand {
    public SOWAndSubscribeCommand(String name) {
        super(name);
        this.addOption(new CommandOption("topic", "topic to query", true));
        this.addOption(new CommandOption("filter", "content filter to use", false));
        this.addOption(new CommandOption("batchsize", "batch size to use during query", false));
        this.addOption(new CommandOption("delta", "request deltas for the subscription", false));
        this.addOption(new CommandOption("bookmark", "bookmark for historical sow query", false));
        this.addOption(new CommandOption("orderby", "orderby expression for sow query", false));
        this.addOption(new CommandOption("topn", "only return top n records for sow query", false));
        this.addOption(new CommandOption("opts", "additional options: comma separated list of [oof,live,send_keys,no_empties]", false));
        this.addOption(new CommandOption("timeout", "timeout to wait for command to return in milliseconds", false));
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark sow_and_subscribe -server localhost:9003 -topic Trades -delta -filter \"/55 = 'Transport.123'\"\n");
        example.append("    Connects to the AMPS instance listening on port 9003");
        example.append("    and prints records in topic 'Trades' that have");
        example.append("    tag 55 set to 'Transport.123' and then return message");
        example.append("    deltas over the subscription.");
        this.addExample(example.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(String[] argv) {
        this.parseArgs(argv, 1);
        String[] userAndServer = ((CommandOption)this.options.get("server")).getValue().split("@", 2);
        String server = userAndServer.length == 2 ? userAndServer[1] : userAndServer[0];
        String topic = ((CommandOption)this.options.get("topic")).getValue();
        String type = ((CommandOption)this.options.get("proto")).getValue();
        boolean delta = ((CommandOption)this.options.get("delta")).hasValue();
        String filter = null;
        String bookmark = null;
        String orderBy = null;
        String opts = null;
        int topN = 0;
        int batchSize = 1;
        int timeout = 5000;
        if (!(type.equals("xml") || type.equals("fix") || type.equals("nvfix") || type.equals("amps") || type.equals("json"))) {
            this.badUsage("prot argument needs to be 'fix', 'xml', 'nvfix', 'amps', or 'json'.");
        }
        if (((CommandOption)this.options.get("filter")).hasValue()) {
            filter = ((CommandOption)this.options.get("filter")).getValue();
        }
        if (((CommandOption)this.options.get("batchsize")).hasValue()) {
            batchSize = Integer.parseInt(((CommandOption)this.options.get("batchsize")).getValue());
        }
        if (((CommandOption)this.options.get("bookmark")).hasValue()) {
            bookmark = ((CommandOption)this.options.get("bookmark")).getValue();
        }
        if (((CommandOption)this.options.get("orderby")).hasValue()) {
            orderBy = ((CommandOption)this.options.get("orderby")).getValue();
        }
        if (((CommandOption)this.options.get("opts")).hasValue()) {
            opts = ((CommandOption)this.options.get("opts")).getValue();
        }
        if (((CommandOption)this.options.get("topn")).hasValue()) {
            topN = Integer.parseInt(((CommandOption)this.options.get("topn")).getValue());
        }
        if (((CommandOption)this.options.get("timeout")).hasValue()) {
            timeout = Integer.parseInt(((CommandOption)this.options.get("timeout")).getValue());
        }
        String userId = userAndServer.length == 2 ? userAndServer[0] : System.getProperty("user.name");
        String clientName = "spark-sow-and-subscribe-" + userId + "-" + UUID.randomUUID().toString();
        Client client = new Client(clientName, 131072);
        SOWAndSubscribeCommandHandler handler = new SOWAndSubscribeCommandHandler();
        client.setDisconnectHandler(handler);
        String uriString = null;
        try {
            uriString = "tcp://" + userId + "@" + server + "/" + type;
            client.connect(uriString);
            client.logon(5000L, this.createAuthenticator(uriString));
        }
        catch (ConnectionException e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        try {
            SOWAndSubscribeCommandHandler e = handler;
            synchronized (e) {
                Message message = client.allocateMessage();
                if (delta) {
                    message.setCommand(1024);
                } else {
                    message.setCommand(256);
                }
                CommandId id = CommandId.nextIdentifier();
                message.setCommandId(id);
                message.setSubId(id);
                message.setQueryId(id);
                message.setAckType(8);
                message.setTopic(topic);
                message.setBatchSize(batchSize);
                if (topN > 0) {
                    message.setTopN(topN);
                }
                if (filter != null) {
                    message.setFilter(filter);
                }
                if (orderBy != null) {
                    message.setOrderBy(orderBy);
                }
                if (opts != null) {
                    message.setOptions(opts);
                }
                if (bookmark != null) {
                    message.setBookmark(bookmark);
                }
                client.send(handler, message, timeout);
                try {
                    handler.wait();
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error sending subscribe request: " + e.toString());
        }
        client.close();
    }

    private static class SOWAndSubscribeCommandHandler
    implements MessageHandler,
    ClientDisconnectHandler {
        private SOWAndSubscribeCommandHandler() {
        }

        public void invoke(Message message) {
            switch (message.getCommand()) {
                case 8192: {
                    break;
                }
                case 8: {
                    System.out.println(message.getData());
                    break;
                }
                case 1: {
                    System.out.println(message.getData());
                    break;
                }
                case 32768: {
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Client client) {
            System.err.println("Disconnected");
            SOWAndSubscribeCommandHandler sOWAndSubscribeCommandHandler = this;
            synchronized (sOWAndSubscribeCommandHandler) {
                this.notifyAll();
            }
        }
    }
}

