/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.Transport;
import com.crankuptheamps.client.exception.TransportTypeException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;

public class TransportFactory {
    private static Hashtable<String, String> registry = new Hashtable();

    public static void register(String name, String className) throws TransportTypeException {
        if (registry.containsKey(name)) {
            throw new TransportTypeException("'" + name + "' is already registered");
        }
        registry.put(name, className);
    }

    public static void unregister(String name) throws TransportTypeException {
        if (!registry.containsKey(name)) {
            throw new TransportTypeException("The TransportType '" + name + "' is not a known TransportType");
        }
        registry.remove(name);
    }

    public static void reset() {
        registry.clear();
    }

    public static Transport createTransport(String name, Protocol messageType, Properties props) throws TransportTypeException {
        String tName = "com.crankuptheamps.client." + name.toUpperCase() + "Transport";
        if (registry.containsKey(name)) {
            tName = registry.get(name);
        }
        try {
            Class<?> c = Class.forName(tName);
            Class[] params = new Class[]{Protocol.class, Properties.class};
            Constructor<?> ctor = c.getConstructor(params);
            Object[] args = new Object[]{messageType, props};
            Transport result = (Transport)ctor.newInstance(args);
            return result;
        }
        catch (Exception e) {
            throw new TransportTypeException("The TransportType '" + name + "' could not be found.");
        }
    }
}

