/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkRingBuffer;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Pool;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.BookmarkRangeField;
import com.crankuptheamps.client.fields.Field;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RingBookmarkStore
implements BookmarkStore {
    MappedByteBuffer _buffer;
    static final int ENTRIES = 16384;
    static final int ENTRY_SIZE = 1024;
    HashMap<Field, Subscription> _map;
    int _free = 16384;
    RandomAccessFile _file;
    FileChannel _channel;
    String _path;
    BookmarkStoreResizeHandler _resizeHandler = null;
    private int _serverVersion = 99999999;
    final Lock _lock = new ReentrantLock();
    Pool<Subscription> _pool;

    public RingBookmarkStore(String path) throws AMPSException {
        this(path, 1);
    }

    public RingBookmarkStore(String path, int targetNumberOfSubscriptions) throws AMPSException {
        try {
            this._path = path;
            this._file = new RandomAccessFile(this._path, "rw");
            this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
        }
        catch (IOException ioex) {
            throw new AMPSException("I/O Error initializing file " + path, ioex);
        }
        this.init();
    }

    @Override
    public long log(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        long seqNo = sub.log(bookmark);
        message.setBookmarkSeqNo(seqNo);
        return seqNo;
    }

    @Override
    public void discard(Field subId, long bookmarkSeqNo) throws AMPSException {
        this.find(subId).discard(bookmarkSeqNo);
    }

    @Override
    public void discard(Message message) throws AMPSException {
        long bookmark = message.getBookmarkSeqNo();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        sub.discard(bookmark);
    }

    @Override
    public Field getMostRecent(Field subId) throws AMPSException {
        return this.find(subId).getMostRecentList(true).copy();
    }

    @Override
    public Field getMostRecent(Field subId, boolean useList) throws AMPSException {
        return this.find(subId).getMostRecentList(useList).copy();
    }

    @Override
    public boolean isDiscarded(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        return sub.isDiscarded(bookmark);
    }

    private void recover() throws AMPSException {
        byte firstByte;
        int currentEntry;
        for (currentEntry = 0; currentEntry < 16384 && (firstByte = this._buffer.get(currentEntry * 1024)) != 0; ++currentEntry) {
            int idLength;
            byte[] id = new byte[243];
            this._buffer.position(currentEntry * 1024);
            this._buffer.get(id);
            for (idLength = 0; idLength < id.length && id[idLength] != 0; ++idLength) {
            }
            Field f = new Field(id, 0, idLength);
            Subscription subscription = this._pool.get();
            subscription.init(this._buffer, currentEntry * 1024);
            try {
                this._map.put(f, subscription);
            }
            catch (Exception e) {
                throw new AMPSException("Bookmark store corrupted.", e);
            }
            subscription.recover();
        }
        if (currentEntry == 16384) {
            throw new AMPSException("Unable to allocate space in this bookmark store.");
        }
        this._free = currentEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription find(Field subId) throws AMPSException {
        this._lock.lock();
        try {
            if (this._map.containsKey(subId)) {
                Subscription subscription = this._map.get(subId);
                return subscription;
            }
            if (this._free >= 16384) {
                throw new AMPSException("Unable to allocate space in this bookmark store.");
            }
            int pos = this._free++;
            Subscription subscription = this._pool.get();
            subscription.init(this._buffer, pos * 1024);
            subscription.setResizeHandler(this._resizeHandler, this);
            this._map.put(subId.copy(), subscription);
            this._buffer.position(pos * 1024);
            for (int i = 0; i < subId.length; ++i) {
                this._buffer.put(subId.buffer[subId.position + i]);
            }
            Subscription subscription2 = subscription;
            return subscription2;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void persisted(Field subId, BookmarkField bookmark) throws AMPSException {
    }

    @Override
    @Deprecated
    public void persisted(Field subId, long bookmark) throws AMPSException {
    }

    @Override
    public long getOldestBookmarkSeq(Field subId) throws AMPSException {
        return this.find(subId).getOldestBookmarkSeq();
    }

    @Override
    public void setResizeHandler(BookmarkStoreResizeHandler handler) {
        this._resizeHandler = handler;
        for (Map.Entry<Field, Subscription> pairs : this._map.entrySet()) {
            pairs.getValue().setResizeHandler(handler, this);
        }
    }

    @Override
    public void purge() throws AMPSException {
        this._lock.lock();
        try {
            int longs = this._buffer.capacity() / 8;
            this._buffer.position(0);
            for (int i = 0; i < longs; ++i) {
                this._buffer.putLong(0L);
            }
            this._buffer.position(0);
            this._buffer.force();
            this._map = new HashMap();
            this._free = 0;
            this.recover();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(Field subId_) throws AMPSException {
        this._lock.lock();
        try {
            int i;
            if (!this._map.containsKey(subId_)) {
                return;
            }
            Subscription sub = this._map.get(subId_);
            int pos = sub._offset / 1024;
            byte[] buf = new byte[1024];
            this._buffer.position(sub._offset);
            this._buffer.put(buf);
            --this._free;
            Field subId = new Field();
            for (int j = pos; j < this._free; ++j) {
                int idLength;
                int i2 = j * 1024;
                this._buffer.position((j + 1) * 1024);
                this._buffer.get(buf);
                this._buffer.position(i2);
                this._buffer.put(buf);
                for (idLength = 0; idLength < 244 && buf[idLength] != 0; ++idLength) {
                }
                subId.set(buf, 0, idLength);
                this._map.get((Object)subId)._offset = i2;
            }
            this._buffer.position(i);
            for (i = this._free * 1024; i < (this._free + 1) * 1024; ++i) {
                this._buffer.put((byte)0);
            }
            this._map.remove(subId_);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void init() throws AMPSException {
        try {
            this._channel = this._file.getChannel();
            this._buffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x1000000L);
            this._channel.close();
            this._file.close();
        }
        catch (IOException ioex) {
            throw new AMPSException("error opening store.", ioex);
        }
        this._map = new HashMap();
        this._free = 0;
        this.recover();
    }

    @Override
    public void setServerVersion(int version) {
        this._serverVersion = version;
    }

    public int getServerVersion() {
        return this._serverVersion;
    }

    @Override
    public void close() throws Exception {
        this._buffer.force();
        this._buffer = null;
        this._map = null;
    }

    protected static class Subscription
    implements com.crankuptheamps.client.Subscription {
        ByteBuffer _buffer;
        int _offset;
        short _currentDiskPosition = 0;
        BookmarkRingBuffer _ring = new BookmarkRingBuffer();
        static final int BYTES_BOOKMARK = 260;
        static final int BYTES_ENTRY = 1024;
        static final short POSITIONS = 3;
        static final int BYTES_SUBID = 244;
        private BookmarkRangeField _range = new BookmarkRangeField();
        final Lock _lock = new ReentrantLock();

        public void init(ByteBuffer buffer, int offset) throws AMPSException {
            this._buffer = buffer;
            this._offset = offset;
            this.recover();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long log(BookmarkField bookmark) throws CommandException {
            this._lock.lock();
            try {
                if (!bookmark.isRange()) {
                    long seq = this._ring.log(bookmark);
                    while (seq == 0L) {
                        this._lock.unlock();
                        try {
                            this._ring.checkResize();
                        }
                        finally {
                            this._lock.lock();
                        }
                        seq = this._ring.log(bookmark);
                    }
                    long l = seq;
                    return l;
                }
                this._range.copyFrom(bookmark);
                if (!this._range.isValid()) {
                    this._range.reset();
                    throw new CommandException("Invalid bookmark range specified");
                }
                long seq = 0L;
                if (this._range.isStartExclusive()) {
                    seq = this._ring.log(this._range.getStart());
                    this._ring.discard(seq);
                }
                this.write(this._range);
                long l = seq;
                return l;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public boolean isDiscarded(BookmarkField bookmark) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard(long bookmark) {
            this._lock.lock();
            try {
                if (this._ring.discard(bookmark)) {
                    if (this._range.isValid()) {
                        BookmarkField recent = this._ring.getLastDiscarded();
                        if (recent.length > 1 && (this._range.isStartInclusive() || !((Field)recent).equals(this._range.getStart()))) {
                            this._range.replaceStart(recent, true);
                            this.write(this._range);
                        }
                    } else {
                        this.write(this._ring.getLastDiscarded());
                    }
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public BookmarkRangeField getRange() {
            this._lock.lock();
            try {
                BookmarkRangeField bookmarkRangeField = this._range.copy();
                return bookmarkRangeField;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public Field getMostRecent() {
            this._lock.lock();
            try {
                BookmarkField bookmarkField = this._ring.getLastDiscarded();
                return bookmarkField;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public Field getMostRecentList(boolean useList) {
            this._lock.lock();
            try {
                if (this._range.isValid()) {
                    BookmarkRangeField bookmarkRangeField = this._range;
                    return bookmarkRangeField;
                }
                BookmarkField bookmarkField = this._ring.getLastDiscarded();
                return bookmarkField;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(Field bookmark) {
            this._lock.lock();
            try {
                int i;
                short nextDiskPosition = (short)((this._currentDiskPosition + 1) % 3);
                this._buffer.put(this._offset + 244 + 260 * nextDiskPosition, (byte)42);
                this._buffer.position(this._offset + 244 + 260 * this._currentDiskPosition + 1);
                for (i = 0; i < bookmark.length; ++i) {
                    this._buffer.put(bookmark.byteAt(i));
                }
                for (i = 0; i < 260 - (bookmark.length + 2); ++i) {
                    this._buffer.put((byte)0);
                }
                this._buffer.put(this._offset + 244 + 260 * this._currentDiskPosition, (byte)43);
                this._currentDiskPosition = nextDiskPosition;
            }
            finally {
                this._lock.unlock();
            }
        }

        private void recover() throws AMPSException {
            byte b;
            int foundCursor;
            for (foundCursor = 0; foundCursor < 3 && (b = this._buffer.get(this._offset + 244 + 260 * foundCursor)) != 42; foundCursor = (int)((short)(foundCursor + 1))) {
            }
            if (foundCursor == 0 && (b = this._buffer.get(this._offset + 244 + 520)) == 42) {
                foundCursor = 2;
            }
            if (foundCursor < 3) {
                int bookmarkLength;
                this._currentDiskPosition = (short)foundCursor;
                int mostRecentValid = this._currentDiskPosition == 0 ? 2 : this._currentDiskPosition - 1;
                byte[] buf = new byte[259];
                this._buffer.position(this._offset + 244 + 260 * mostRecentValid + 1);
                this._buffer.get(buf);
                for (bookmarkLength = 0; bookmarkLength < buf.length && buf[bookmarkLength] != 0; ++bookmarkLength) {
                }
                try {
                    BookmarkField f = new BookmarkField();
                    f.set(buf, 0, bookmarkLength);
                    if (f.isRange()) {
                        this.log(f);
                    }
                    this._ring.discard(this._ring.log(f));
                }
                catch (Exception e) {
                    throw new AMPSException("Error while recovering.", e);
                }
            } else {
                this._currentDiskPosition = 0;
            }
        }

        @Override
        @Deprecated
        public void setLastPersisted(long bookmark) {
        }

        @Override
        public void setLastPersisted(BookmarkField bookmark) {
        }

        @Override
        public long getOldestBookmarkSeq() {
            return this._ring.getStartIndex();
        }

        @Override
        public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
            this._ring.setResizeHandler(handler, store);
        }
    }
}

