/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.exception.CommandException;
import java.nio.charset.StandardCharsets;

public class FIXBuilder {
    private static final int MIN_CAPACITY = 8;
    private byte[] _buffer = null;
    private int _size = 0;
    private int _capacity = 1024;
    private final byte _fieldSeparator;

    public FIXBuilder(int capacity, byte fieldSeparator) {
        this._fieldSeparator = fieldSeparator;
        this._capacity = capacity < 8 ? 8 : capacity;
        this._buffer = new byte[this._capacity];
    }

    public void clear() {
        this._size = 0;
    }

    public int getSize() {
        return this._size;
    }

    public byte[] getBytes() {
        return this._buffer;
    }

    private int ruLog10(int tag) {
        long scalar = 10L;
        for (int j = 1; j < 20; ++j) {
            if ((long)tag < scalar) {
                return j;
            }
            scalar *= 10L;
        }
        return 0;
    }

    private void checkCapacity(int bytesNeeded) {
        if (this._capacity - this._size < bytesNeeded) {
            while (this._capacity - this._size < bytesNeeded) {
                this._capacity *= 2;
            }
            byte[] newbuf = new byte[this._capacity];
            System.arraycopy(this._buffer, 0, newbuf, 0, this._size);
            this._buffer = newbuf;
        }
    }

    public FIXBuilder append(int tag, byte[] value, int offset, int length) throws CommandException {
        if (tag < 0) {
            throw new IllegalArgumentException("negative tag used in FIXBuilder");
        }
        int tagSize = this.ruLog10(tag);
        int sizeNeeded = tagSize + length + 2;
        this.checkCapacity(sizeNeeded);
        int writeIndex = this._size + tagSize;
        for (int j = 1; j <= tagSize; ++j) {
            this._buffer[writeIndex - j] = (byte)(48 + tag % 10);
            tag /= 10;
        }
        this._buffer[writeIndex] = 61;
        System.arraycopy(value, offset, this._buffer, ++writeIndex, length);
        this._buffer[writeIndex += length] = this._fieldSeparator;
        this._size += sizeNeeded;
        return this;
    }

    public FIXBuilder append(int tag, byte[] value) throws CommandException {
        return this.append(tag, value, 0, value.length);
    }

    public FIXBuilder append(int tag, String value) throws CommandException {
        return this.append(tag, FIXBuilder.toBytes(value));
    }

    private static byte[] toBytes(String datum) {
        return datum.getBytes(StandardCharsets.ISO_8859_1);
    }
}

