/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.ReconnectDelayStrategy;
import com.crankuptheamps.client.exception.AMPSException;

public class ExponentialDelayStrategy
implements ReconnectDelayStrategy {
    public static final int DEFAULT_DELAY = 200;
    public static final int DEFAULT_MAXIMUM_DELAY = 20000;
    public static final double DEFAULT_BACKOFF_EXPONENT = 2.0;
    public static final int DEFAULT_MAXIMUM_RETRY_TIME = 0;
    public static final double DEFAULT_JITTER = 1.0;
    protected int _initialDelay = 200;
    protected int _maximumDelay = 20000;
    protected double _backoffExponent = 2.0;
    protected int _maximumRetryTime = 0;
    protected double _jitter = 1.0;
    protected int _currentDelay = this._initialDelay;
    protected String _lastUri;
    protected String _firstUri;
    protected long _startTime = 0L;

    public ExponentialDelayStrategy setInitialDelay(int initialDelay_) {
        this._initialDelay = initialDelay_;
        this._currentDelay = initialDelay_;
        return this;
    }

    public ExponentialDelayStrategy setMaximumDelay(int maximumDelay_) {
        this._maximumDelay = maximumDelay_;
        return this;
    }

    public ExponentialDelayStrategy setBackoffExponent(double exponent_) {
        this._backoffExponent = exponent_;
        return this;
    }

    public ExponentialDelayStrategy setMaximumRetryTime(int maximumRetryTime_) {
        this._maximumRetryTime = maximumRetryTime_;
        return this;
    }

    public ExponentialDelayStrategy setJitter(double jitter_) {
        this._jitter = jitter_;
        return this;
    }

    @Override
    public int getConnectWaitDuration(String uri_) throws Exception {
        this._throwIfMaximumExceeded();
        if (this._lastUri == null || !this._lastUri.equals(uri_)) {
            this._lastUri = uri_;
            if (this._firstUri != null && this._firstUri.equals(uri_)) {
                return this._currentDurationAndIncrease();
            }
            if (this._firstUri == null) {
                this._firstUri = uri_;
            }
            return 0;
        }
        return this._currentDurationAndIncrease();
    }

    @Override
    public void reset() {
        this._lastUri = null;
        this._firstUri = null;
        this._currentDelay = this._initialDelay;
        this._startTime = 0L;
    }

    protected void _throwIfMaximumExceeded() throws MaximumRetryExceeded {
        if (this._maximumRetryTime > 0) {
            long now = System.currentTimeMillis();
            if (this._startTime > 0L) {
                if (now - this._startTime > (long)this._maximumRetryTime) {
                    throw new MaximumRetryExceeded();
                }
            } else {
                this._startTime = now;
            }
        }
    }

    protected int _currentDurationAndIncrease() throws MaximumRetryExceeded {
        int timeElapsed;
        int maxJitter;
        int newDelay = (int)((double)this._currentDelay * this._backoffExponent);
        if (newDelay > this._maximumDelay) {
            newDelay = this._maximumDelay;
        }
        if ((maxJitter = (int)(this._jitter * (double)this._initialDelay)) > this._maximumDelay) {
            maxJitter = this._maximumDelay;
        }
        int currentDelay = this._currentDelay;
        if (this._jitter > 0.0) {
            if (currentDelay > this._maximumDelay - maxJitter) {
                int n = currentDelay = this._maximumDelay - maxJitter > this._initialDelay ? this._maximumDelay - maxJitter : this._initialDelay;
            }
            if ((currentDelay += (int)(Math.random() * this._jitter * (double)this._initialDelay)) > this._maximumDelay) {
                currentDelay = this._maximumDelay;
            }
        }
        if (this._maximumRetryTime > 0 && (timeElapsed = (int)(System.currentTimeMillis() - this._startTime)) + currentDelay > this._maximumRetryTime) {
            if (timeElapsed > this._maximumRetryTime) {
                throw new MaximumRetryExceeded();
            }
            currentDelay = this._maximumRetryTime - timeElapsed;
        }
        this._currentDelay = newDelay;
        return currentDelay;
    }

    public static class MaximumRetryExceeded
    extends AMPSException {
        private static final long serialVersionUID = 1L;
    }
}

